

optimize_unconst <- function(dat, idx_test, fmla){
 
 fmla_a = fmla$fmla_a
 fmla_m = fmla$fmla_m
 fmla_l = fmla$fmla_l
 fmla_y = fmla$fmla_y
 
 beta_y = lm(fmla_y, dat[-idx_test,])$coefficients
 beta_l = glm(fmla_l, data=dat[-idx_test,], family="binomial")$coefficients
 beta_m = glm(fmla_m, data=dat[-idx_test,], family="binomial")$coefficients
 beta_a = glm(fmla_a, data=dat[-idx_test,], family="binomial")$coefficients
 
 # Prediction
 Xa = as.matrix(model.matrix(fmla_a, data=model.frame(dat, na.action = NULL)))
 Xm = as.matrix(model.matrix(fmla_m, data=model.frame(dat, na.action = NULL)))
 Xl = as.matrix(model.matrix(fmla_l, data=model.frame(dat, na.action = NULL)))
 Xy = as.matrix(model.matrix(fmla_y, data=model.frame(dat, na.action = NULL)))
 A = dat$A
 M = dat$M 
 L = dat$L
 Y = dat$Y
 
 Yhat = Xy%*%beta_y
 phat_L1 = 1/(1 + exp(-Xl%*%beta_l))
 phat_M1 = 1/(1 + exp(-Xm%*%beta_m))
 phat_A1 = 1/(1 + exp(-Xa%*%beta_a))
 
 return(list(beta_a=beta_a, 
             beta_m=beta_m, 
             beta_l=beta_l, 
             beta_y=beta_y, 
             Yhat=Yhat, 
             p_L1=phat_L1, 
             p_M1=phat_M1, 
             p_A1=phat_A1))
}